// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Compute.Models
{
    internal static partial class SupportedOperatingSystemTypeExtensions
    {
        public static string ToSerialString(this SupportedOperatingSystemType value) => value switch
        {
            SupportedOperatingSystemType.Windows => "Windows",
            SupportedOperatingSystemType.Linux => "Linux",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SupportedOperatingSystemType value.")
        };

        public static SupportedOperatingSystemType ToSupportedOperatingSystemType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Windows")) return SupportedOperatingSystemType.Windows;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Linux")) return SupportedOperatingSystemType.Linux;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SupportedOperatingSystemType value.");
        }
    }
}
