// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> List of supported capabilities persisted on the disk resource for VM use. </summary>
    public partial class SupportedCapabilities
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SupportedCapabilities"/>. </summary>
        public SupportedCapabilities()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SupportedCapabilities"/>. </summary>
        /// <param name="diskControllerTypes"> The disk controllers that an OS disk supports. If set it can be SCSI or SCSI, NVME or NVME, SCSI. </param>
        /// <param name="acceleratedNetwork"> True if the image from which the OS disk is created supports accelerated networking. </param>
        /// <param name="architecture"> CPU architecture supported by an OS disk. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SupportedCapabilities(string diskControllerTypes, bool? acceleratedNetwork, ArchitectureType? architecture, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DiskControllerTypes = diskControllerTypes;
            AcceleratedNetwork = acceleratedNetwork;
            Architecture = architecture;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The disk controllers that an OS disk supports. If set it can be SCSI or SCSI, NVME or NVME, SCSI. </summary>
        public string DiskControllerTypes { get; set; }
        /// <summary> True if the image from which the OS disk is created supports accelerated networking. </summary>
        public bool? AcceleratedNetwork { get; set; }
        /// <summary> CPU architecture supported by an OS disk. </summary>
        public ArchitectureType? Architecture { get; set; }
    }
}
