// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Specifies the storage account type for the managed disk. Managed OS disk storage account type can only be set when you create the scale set. NOTE: UltraSSD_LRS can only be used with data disks. It cannot be used with OS Disk. Standard_LRS uses Standard HDD. StandardSSD_LRS uses Standard SSD. Premium_LRS uses Premium SSD. UltraSSD_LRS uses Ultra disk. Premium_ZRS uses Premium SSD zone redundant storage. StandardSSD_ZRS uses Standard SSD zone redundant storage. For more information regarding disks supported for Windows Virtual Machines, refer to https://docs.microsoft.com/azure/virtual-machines/windows/disks-types and, for Linux Virtual Machines, refer to https://docs.microsoft.com/azure/virtual-machines/linux/disks-types. </summary>
    public readonly partial struct StorageAccountType : IEquatable<StorageAccountType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageAccountType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageAccountType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardLrsValue = "Standard_LRS";
        private const string PremiumLrsValue = "Premium_LRS";
        private const string StandardSsdLrsValue = "StandardSSD_LRS";
        private const string UltraSsdLrsValue = "UltraSSD_LRS";
        private const string PremiumZrsValue = "Premium_ZRS";
        private const string StandardSsdZrsValue = "StandardSSD_ZRS";
        private const string PremiumV2LrsValue = "PremiumV2_LRS";

        /// <summary> Standard_LRS. </summary>
        public static StorageAccountType StandardLrs { get; } = new StorageAccountType(StandardLrsValue);
        /// <summary> Premium_LRS. </summary>
        public static StorageAccountType PremiumLrs { get; } = new StorageAccountType(PremiumLrsValue);
        /// <summary> StandardSSD_LRS. </summary>
        public static StorageAccountType StandardSsdLrs { get; } = new StorageAccountType(StandardSsdLrsValue);
        /// <summary> UltraSSD_LRS. </summary>
        public static StorageAccountType UltraSsdLrs { get; } = new StorageAccountType(UltraSsdLrsValue);
        /// <summary> Premium_ZRS. </summary>
        public static StorageAccountType PremiumZrs { get; } = new StorageAccountType(PremiumZrsValue);
        /// <summary> StandardSSD_ZRS. </summary>
        public static StorageAccountType StandardSsdZrs { get; } = new StorageAccountType(StandardSsdZrsValue);
        /// <summary> PremiumV2_LRS. </summary>
        public static StorageAccountType PremiumV2Lrs { get; } = new StorageAccountType(PremiumV2LrsValue);
        /// <summary> Determines if two <see cref="StorageAccountType"/> values are the same. </summary>
        public static bool operator ==(StorageAccountType left, StorageAccountType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageAccountType"/> values are not the same. </summary>
        public static bool operator !=(StorageAccountType left, StorageAccountType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageAccountType"/>. </summary>
        public static implicit operator StorageAccountType(string value) => new StorageAccountType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageAccountType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageAccountType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
