// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The sku name. </summary>
    public readonly partial struct SnapshotStorageAccountType : IEquatable<SnapshotStorageAccountType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SnapshotStorageAccountType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SnapshotStorageAccountType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardLrsValue = "Standard_LRS";
        private const string PremiumLrsValue = "Premium_LRS";
        private const string StandardZrsValue = "Standard_ZRS";

        /// <summary> Standard HDD locally redundant storage. </summary>
        public static SnapshotStorageAccountType StandardLrs { get; } = new SnapshotStorageAccountType(StandardLrsValue);
        /// <summary> Premium SSD locally redundant storage. </summary>
        public static SnapshotStorageAccountType PremiumLrs { get; } = new SnapshotStorageAccountType(PremiumLrsValue);
        /// <summary> Standard zone redundant storage. </summary>
        public static SnapshotStorageAccountType StandardZrs { get; } = new SnapshotStorageAccountType(StandardZrsValue);
        /// <summary> Determines if two <see cref="SnapshotStorageAccountType"/> values are the same. </summary>
        public static bool operator ==(SnapshotStorageAccountType left, SnapshotStorageAccountType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SnapshotStorageAccountType"/> values are not the same. </summary>
        public static bool operator !=(SnapshotStorageAccountType left, SnapshotStorageAccountType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SnapshotStorageAccountType"/>. </summary>
        public static implicit operator SnapshotStorageAccountType(string value) => new SnapshotStorageAccountType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SnapshotStorageAccountType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SnapshotStorageAccountType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
