// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> This property allows you to specify the operation type of gallery sharing update. Possible values are: **Add,** **Remove,** **Reset.**. </summary>
    public readonly partial struct SharingUpdateOperationType : IEquatable<SharingUpdateOperationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SharingUpdateOperationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SharingUpdateOperationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AddValue = "Add";
        private const string RemoveValue = "Remove";
        private const string ResetValue = "Reset";
        private const string EnableCommunityValue = "EnableCommunity";

        /// <summary> Add. </summary>
        public static SharingUpdateOperationType Add { get; } = new SharingUpdateOperationType(AddValue);
        /// <summary> Remove. </summary>
        public static SharingUpdateOperationType Remove { get; } = new SharingUpdateOperationType(RemoveValue);
        /// <summary> Reset. </summary>
        public static SharingUpdateOperationType Reset { get; } = new SharingUpdateOperationType(ResetValue);
        /// <summary> EnableCommunity. </summary>
        public static SharingUpdateOperationType EnableCommunity { get; } = new SharingUpdateOperationType(EnableCommunityValue);
        /// <summary> Determines if two <see cref="SharingUpdateOperationType"/> values are the same. </summary>
        public static bool operator ==(SharingUpdateOperationType left, SharingUpdateOperationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SharingUpdateOperationType"/> values are not the same. </summary>
        public static bool operator !=(SharingUpdateOperationType left, SharingUpdateOperationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SharingUpdateOperationType"/>. </summary>
        public static implicit operator SharingUpdateOperationType(string value) => new SharingUpdateOperationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SharingUpdateOperationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SharingUpdateOperationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
