// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> This property allows you to specify the type of sharing group. Possible values are: **Subscriptions,** **AADTenants.**. </summary>
    public readonly partial struct SharingProfileGroupType : IEquatable<SharingProfileGroupType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SharingProfileGroupType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SharingProfileGroupType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SubscriptionsValue = "Subscriptions";
        private const string AADTenantsValue = "AADTenants";

        /// <summary> Subscriptions. </summary>
        public static SharingProfileGroupType Subscriptions { get; } = new SharingProfileGroupType(SubscriptionsValue);
        /// <summary> AADTenants. </summary>
        public static SharingProfileGroupType AADTenants { get; } = new SharingProfileGroupType(AADTenantsValue);
        /// <summary> Determines if two <see cref="SharingProfileGroupType"/> values are the same. </summary>
        public static bool operator ==(SharingProfileGroupType left, SharingProfileGroupType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SharingProfileGroupType"/> values are not the same. </summary>
        public static bool operator !=(SharingProfileGroupType left, SharingProfileGroupType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SharingProfileGroupType"/>. </summary>
        public static implicit operator SharingProfileGroupType(string value) => new SharingProfileGroupType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SharingProfileGroupType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SharingProfileGroupType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
