// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Profile for gallery sharing to subscription or tenant. </summary>
    public partial class SharingProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SharingProfile"/>. </summary>
        public SharingProfile()
        {
            Groups = new ChangeTrackingList<SharingProfileGroup>();
        }

        /// <summary> Initializes a new instance of <see cref="SharingProfile"/>. </summary>
        /// <param name="permission"> This property allows you to specify the permission of sharing gallery. Possible values are: **Private,** **Groups,** **Community.**. </param>
        /// <param name="groups"> A list of sharing profile groups. </param>
        /// <param name="communityGalleryInfo"> Information of community gallery if current gallery is shared to community. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SharingProfile(GallerySharingPermissionType? permission, IReadOnlyList<SharingProfileGroup> groups, CommunityGalleryInfo communityGalleryInfo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Permission = permission;
            Groups = groups;
            CommunityGalleryInfo = communityGalleryInfo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> This property allows you to specify the permission of sharing gallery. Possible values are: **Private,** **Groups,** **Community.**. </summary>
        public GallerySharingPermissionType? Permission { get; set; }
        /// <summary> A list of sharing profile groups. </summary>
        public IReadOnlyList<SharingProfileGroup> Groups { get; }
        /// <summary> Information of community gallery if current gallery is shared to community. </summary>
        public CommunityGalleryInfo CommunityGalleryInfo { get; set; }
    }
}
