// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The SelectPermission. </summary>
    public readonly partial struct SelectPermission : IEquatable<SelectPermission>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SelectPermission"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SelectPermission(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PermissionsValue = "Permissions";

        /// <summary> Permissions. </summary>
        public static SelectPermission Permissions { get; } = new SelectPermission(PermissionsValue);
        /// <summary> Determines if two <see cref="SelectPermission"/> values are the same. </summary>
        public static bool operator ==(SelectPermission left, SelectPermission right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SelectPermission"/> values are not the same. </summary>
        public static bool operator !=(SelectPermission left, SelectPermission right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SelectPermission"/>. </summary>
        public static implicit operator SelectPermission(string value) => new SelectPermission(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SelectPermission other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SelectPermission other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
