// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Compute.Models
{
    internal partial class ScheduledEventsAdditionalPublishingTargets : IUtf8JsonSerializable, IJsonModel<ScheduledEventsAdditionalPublishingTargets>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ScheduledEventsAdditionalPublishingTargets>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ScheduledEventsAdditionalPublishingTargets>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScheduledEventsAdditionalPublishingTargets>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScheduledEventsAdditionalPublishingTargets)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(EventGridAndResourceGraph))
            {
                writer.WritePropertyName("eventGridAndResourceGraph"u8);
                writer.WriteObjectValue(EventGridAndResourceGraph, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ScheduledEventsAdditionalPublishingTargets IJsonModel<ScheduledEventsAdditionalPublishingTargets>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScheduledEventsAdditionalPublishingTargets>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScheduledEventsAdditionalPublishingTargets)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeScheduledEventsAdditionalPublishingTargets(document.RootElement, options);
        }

        internal static ScheduledEventsAdditionalPublishingTargets DeserializeScheduledEventsAdditionalPublishingTargets(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            EventGridAndResourceGraph eventGridAndResourceGraph = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("eventGridAndResourceGraph"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    eventGridAndResourceGraph = EventGridAndResourceGraph.DeserializeEventGridAndResourceGraph(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ScheduledEventsAdditionalPublishingTargets(eventGridAndResourceGraph, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ScheduledEventsAdditionalPublishingTargets>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScheduledEventsAdditionalPublishingTargets>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ScheduledEventsAdditionalPublishingTargets)} does not support writing '{options.Format}' format.");
            }
        }

        ScheduledEventsAdditionalPublishingTargets IPersistableModel<ScheduledEventsAdditionalPublishingTargets>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScheduledEventsAdditionalPublishingTargets>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeScheduledEventsAdditionalPublishingTargets(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ScheduledEventsAdditionalPublishingTargets)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ScheduledEventsAdditionalPublishingTargets>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
