// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Describes the properties of a run command parameter. </summary>
    public partial class RunCommandParameterDefinition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RunCommandParameterDefinition"/>. </summary>
        /// <param name="name"> The run command parameter name. </param>
        /// <param name="runCommandParameterDefinitionType"> The run command parameter type. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="runCommandParameterDefinitionType"/> is null. </exception>
        internal RunCommandParameterDefinition(string name, string runCommandParameterDefinitionType)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(runCommandParameterDefinitionType, nameof(runCommandParameterDefinitionType));

            Name = name;
            RunCommandParameterDefinitionType = runCommandParameterDefinitionType;
        }

        /// <summary> Initializes a new instance of <see cref="RunCommandParameterDefinition"/>. </summary>
        /// <param name="name"> The run command parameter name. </param>
        /// <param name="runCommandParameterDefinitionType"> The run command parameter type. </param>
        /// <param name="defaultValue"> The run command parameter default value. </param>
        /// <param name="required"> The run command parameter required. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RunCommandParameterDefinition(string name, string runCommandParameterDefinitionType, string defaultValue, bool? required, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            RunCommandParameterDefinitionType = runCommandParameterDefinitionType;
            DefaultValue = defaultValue;
            Required = required;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RunCommandParameterDefinition"/> for deserialization. </summary>
        internal RunCommandParameterDefinition()
        {
        }

        /// <summary> The run command parameter name. </summary>
        public string Name { get; }
        /// <summary> The run command parameter type. </summary>
        public string RunCommandParameterDefinitionType { get; }
        /// <summary> The run command parameter default value. </summary>
        public string DefaultValue { get; }
        /// <summary> The run command parameter required. </summary>
        public bool? Required { get; }
    }
}
