// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Capture Virtual Machine parameters. </summary>
    public partial class RunCommandInput
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RunCommandInput"/>. </summary>
        /// <param name="commandId"> The run command id. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="commandId"/> is null. </exception>
        public RunCommandInput(string commandId)
        {
            Argument.AssertNotNull(commandId, nameof(commandId));

            CommandId = commandId;
            Script = new ChangeTrackingList<string>();
            Parameters = new ChangeTrackingList<RunCommandInputParameter>();
        }

        /// <summary> Initializes a new instance of <see cref="RunCommandInput"/>. </summary>
        /// <param name="commandId"> The run command id. </param>
        /// <param name="script"> Optional. The script to be executed.  When this value is given, the given script will override the default script of the command. </param>
        /// <param name="parameters"> The run command parameters. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RunCommandInput(string commandId, IList<string> script, IList<RunCommandInputParameter> parameters, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CommandId = commandId;
            Script = script;
            Parameters = parameters;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RunCommandInput"/> for deserialization. </summary>
        internal RunCommandInput()
        {
        }

        /// <summary> The run command id. </summary>
        public string CommandId { get; }
        /// <summary> Optional. The script to be executed.  When this value is given, the given script will override the default script of the command. </summary>
        public IList<string> Script { get; }
        /// <summary> The run command parameters. </summary>
        public IList<RunCommandInputParameter> Parameters { get; }
    }
}
