// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The configuration parameters used while performing a rolling upgrade. </summary>
    public partial class RollingUpgradePolicy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RollingUpgradePolicy"/>. </summary>
        public RollingUpgradePolicy()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RollingUpgradePolicy"/>. </summary>
        /// <param name="maxBatchInstancePercent"> The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability. The default value for this parameter is 20%. </param>
        /// <param name="maxUnhealthyInstancePercent"> The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The default value for this parameter is 20%. </param>
        /// <param name="maxUnhealthyUpgradedInstancePercent"> The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The default value for this parameter is 20%. </param>
        /// <param name="pauseTimeBetweenBatches"> The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format. The default value is 0 seconds (PT0S). </param>
        /// <param name="enableCrossZoneUpgrade"> Allow VMSS to ignore AZ boundaries when constructing upgrade batches. Take into consideration the Update Domain and maxBatchInstancePercent to determine the batch size. </param>
        /// <param name="prioritizeUnhealthyInstances"> Upgrade all unhealthy instances in a scale set before any healthy instances. </param>
        /// <param name="rollbackFailedInstancesOnPolicyBreach"> Rollback failed instances to previous model if the Rolling Upgrade policy is violated. </param>
        /// <param name="isMaxSurgeEnabled"> Create new virtual machines to upgrade the scale set, rather than updating the existing virtual machines. Existing virtual machines will be deleted once the new virtual machines are created for each batch. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RollingUpgradePolicy(int? maxBatchInstancePercent, int? maxUnhealthyInstancePercent, int? maxUnhealthyUpgradedInstancePercent, string pauseTimeBetweenBatches, bool? enableCrossZoneUpgrade, bool? prioritizeUnhealthyInstances, bool? rollbackFailedInstancesOnPolicyBreach, bool? isMaxSurgeEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MaxBatchInstancePercent = maxBatchInstancePercent;
            MaxUnhealthyInstancePercent = maxUnhealthyInstancePercent;
            MaxUnhealthyUpgradedInstancePercent = maxUnhealthyUpgradedInstancePercent;
            PauseTimeBetweenBatches = pauseTimeBetweenBatches;
            EnableCrossZoneUpgrade = enableCrossZoneUpgrade;
            PrioritizeUnhealthyInstances = prioritizeUnhealthyInstances;
            RollbackFailedInstancesOnPolicyBreach = rollbackFailedInstancesOnPolicyBreach;
            IsMaxSurgeEnabled = isMaxSurgeEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability. The default value for this parameter is 20%. </summary>
        public int? MaxBatchInstancePercent { get; set; }
        /// <summary> The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The default value for this parameter is 20%. </summary>
        public int? MaxUnhealthyInstancePercent { get; set; }
        /// <summary> The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The default value for this parameter is 20%. </summary>
        public int? MaxUnhealthyUpgradedInstancePercent { get; set; }
        /// <summary> The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format. The default value is 0 seconds (PT0S). </summary>
        public string PauseTimeBetweenBatches { get; set; }
        /// <summary> Allow VMSS to ignore AZ boundaries when constructing upgrade batches. Take into consideration the Update Domain and maxBatchInstancePercent to determine the batch size. </summary>
        public bool? EnableCrossZoneUpgrade { get; set; }
        /// <summary> Upgrade all unhealthy instances in a scale set before any healthy instances. </summary>
        public bool? PrioritizeUnhealthyInstances { get; set; }
        /// <summary> Rollback failed instances to previous model if the Rolling Upgrade policy is violated. </summary>
        public bool? RollbackFailedInstancesOnPolicyBreach { get; set; }
        /// <summary> Create new virtual machines to upgrade the scale set, rather than updating the existing virtual machines. Existing virtual machines will be deleted once the new virtual machines are created for each batch. </summary>
        public bool? IsMaxSurgeEnabled { get; set; }
    }
}
