// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Information about rollback on failed VM instances after a OS Upgrade operation. </summary>
    public partial class RollbackStatusInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RollbackStatusInfo"/>. </summary>
        internal RollbackStatusInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RollbackStatusInfo"/>. </summary>
        /// <param name="successfullyRolledbackInstanceCount"> The number of instances which have been successfully rolled back. </param>
        /// <param name="failedRolledbackInstanceCount"> The number of instances which failed to rollback. </param>
        /// <param name="rollbackError"> Error details if OS rollback failed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RollbackStatusInfo(int? successfullyRolledbackInstanceCount, int? failedRolledbackInstanceCount, ComputeApiError rollbackError, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SuccessfullyRolledbackInstanceCount = successfullyRolledbackInstanceCount;
            FailedRolledbackInstanceCount = failedRolledbackInstanceCount;
            RollbackError = rollbackError;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The number of instances which have been successfully rolled back. </summary>
        public int? SuccessfullyRolledbackInstanceCount { get; }
        /// <summary> The number of instances which failed to rollback. </summary>
        public int? FailedRolledbackInstanceCount { get; }
        /// <summary> Error details if OS rollback failed. </summary>
        public ComputeApiError RollbackError { get; }
    }
}
