// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The instance view of the role instance. </summary>
    public partial class RoleInstanceView
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RoleInstanceView"/>. </summary>
        internal RoleInstanceView()
        {
            Statuses = new ChangeTrackingList<ResourceInstanceViewStatus>();
        }

        /// <summary> Initializes a new instance of <see cref="RoleInstanceView"/>. </summary>
        /// <param name="platformUpdateDomain"> The Update Domain. </param>
        /// <param name="platformFaultDomain"> The Fault Domain. </param>
        /// <param name="privateId"> Specifies a unique identifier generated internally for the cloud service associated with this role instance. &lt;br /&gt;&lt;br /&gt; NOTE: If you are using Azure Diagnostics extension, this property can be used as 'DeploymentId' for querying details. </param>
        /// <param name="statuses"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RoleInstanceView(int? platformUpdateDomain, int? platformFaultDomain, string privateId, IReadOnlyList<ResourceInstanceViewStatus> statuses, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PlatformUpdateDomain = platformUpdateDomain;
            PlatformFaultDomain = platformFaultDomain;
            PrivateId = privateId;
            Statuses = statuses;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Update Domain. </summary>
        public int? PlatformUpdateDomain { get; }
        /// <summary> The Fault Domain. </summary>
        public int? PlatformFaultDomain { get; }
        /// <summary> Specifies a unique identifier generated internally for the cloud service associated with this role instance. &lt;br /&gt;&lt;br /&gt; NOTE: If you are using Azure Diagnostics extension, this property can be used as 'DeploymentId' for querying details. </summary>
        public string PrivateId { get; }
        /// <summary> Gets the statuses. </summary>
        public IReadOnlyList<ResourceInstanceViewStatus> Statuses { get; }
    }
}
