// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Describes a data disk. </summary>
    public partial class RestorePointSourceVmDataDisk
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RestorePointSourceVmDataDisk"/>. </summary>
        public RestorePointSourceVmDataDisk()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RestorePointSourceVmDataDisk"/>. </summary>
        /// <param name="lun"> Gets the logical unit number. </param>
        /// <param name="name"> Gets the disk name. </param>
        /// <param name="caching"> Gets the caching type. </param>
        /// <param name="diskSizeGB"> Gets the initial disk size in GB for blank data disks, and the new desired size for existing OS and Data disks. </param>
        /// <param name="managedDisk"> Contains the managed disk details. </param>
        /// <param name="diskRestorePoint"> Contains Disk Restore Point properties. </param>
        /// <param name="writeAcceleratorEnabled"> Shows true if the disk is write-accelerator enabled. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RestorePointSourceVmDataDisk(int? lun, string name, CachingType? caching, int? diskSizeGB, VirtualMachineManagedDisk managedDisk, DiskRestorePointAttributes diskRestorePoint, bool? writeAcceleratorEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Lun = lun;
            Name = name;
            Caching = caching;
            DiskSizeGB = diskSizeGB;
            ManagedDisk = managedDisk;
            DiskRestorePoint = diskRestorePoint;
            WriteAcceleratorEnabled = writeAcceleratorEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the logical unit number. </summary>
        public int? Lun { get; }
        /// <summary> Gets the disk name. </summary>
        public string Name { get; }
        /// <summary> Gets the caching type. </summary>
        public CachingType? Caching { get; }
        /// <summary> Gets the initial disk size in GB for blank data disks, and the new desired size for existing OS and Data disks. </summary>
        public int? DiskSizeGB { get; }
        /// <summary> Contains the managed disk details. </summary>
        public VirtualMachineManagedDisk ManagedDisk { get; set; }
        /// <summary> Contains Disk Restore Point properties. </summary>
        public DiskRestorePointAttributes DiskRestorePoint { get; set; }
        /// <summary> Shows true if the disk is write-accelerator enabled. </summary>
        public bool? WriteAcceleratorEnabled { get; }
    }
}
