// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Update Restore Point collection parameters. </summary>
    public partial class RestorePointGroupPatch : ComputeResourcePatch
    {
        /// <summary> Initializes a new instance of <see cref="RestorePointGroupPatch"/>. </summary>
        public RestorePointGroupPatch()
        {
            RestorePoints = new ChangeTrackingList<RestorePointData>();
        }

        /// <summary> Initializes a new instance of <see cref="RestorePointGroupPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="source"> The properties of the source resource that this restore point collection is created from. </param>
        /// <param name="provisioningState"> The provisioning state of the restore point collection. </param>
        /// <param name="restorePointGroupId"> The unique id of the restore point collection. </param>
        /// <param name="restorePoints"> A list containing all restore points created under this restore point collection. </param>
        internal RestorePointGroupPatch(IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, RestorePointGroupSource source, string provisioningState, string restorePointGroupId, IReadOnlyList<RestorePointData> restorePoints) : base(tags, serializedAdditionalRawData)
        {
            Source = source;
            ProvisioningState = provisioningState;
            RestorePointGroupId = restorePointGroupId;
            RestorePoints = restorePoints;
        }

        /// <summary> The properties of the source resource that this restore point collection is created from. </summary>
        public RestorePointGroupSource Source { get; set; }
        /// <summary> The provisioning state of the restore point collection. </summary>
        public string ProvisioningState { get; }
        /// <summary> The unique id of the restore point collection. </summary>
        public string RestorePointGroupId { get; }
        /// <summary> A list containing all restore points created under this restore point collection. </summary>
        public IReadOnlyList<RestorePointData> RestorePoints { get; }
    }
}
