// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The RestorePointGroupExpand. </summary>
    public readonly partial struct RestorePointGroupExpand : IEquatable<RestorePointGroupExpand>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RestorePointGroupExpand"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RestorePointGroupExpand(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RestorePointsValue = "restorePoints";

        /// <summary> restorePoints. </summary>
        public static RestorePointGroupExpand RestorePoints { get; } = new RestorePointGroupExpand(RestorePointsValue);
        /// <summary> Determines if two <see cref="RestorePointGroupExpand"/> values are the same. </summary>
        public static bool operator ==(RestorePointGroupExpand left, RestorePointGroupExpand right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RestorePointGroupExpand"/> values are not the same. </summary>
        public static bool operator !=(RestorePointGroupExpand left, RestorePointGroupExpand right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RestorePointGroupExpand"/>. </summary>
        public static implicit operator RestorePointGroupExpand(string value) => new RestorePointGroupExpand(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RestorePointGroupExpand other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RestorePointGroupExpand other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
