// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The type of key used to encrypt the data of the disk restore point. </summary>
    public readonly partial struct RestorePointEncryptionType : IEquatable<RestorePointEncryptionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RestorePointEncryptionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RestorePointEncryptionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EncryptionAtRestWithPlatformKeyValue = "EncryptionAtRestWithPlatformKey";
        private const string EncryptionAtRestWithCustomerKeyValue = "EncryptionAtRestWithCustomerKey";
        private const string EncryptionAtRestWithPlatformAndCustomerKeysValue = "EncryptionAtRestWithPlatformAndCustomerKeys";

        /// <summary> Disk Restore Point is encrypted at rest with Platform managed key. </summary>
        public static RestorePointEncryptionType EncryptionAtRestWithPlatformKey { get; } = new RestorePointEncryptionType(EncryptionAtRestWithPlatformKeyValue);
        /// <summary> Disk Restore Point is encrypted at rest with Customer managed key that can be changed and revoked by a customer. </summary>
        public static RestorePointEncryptionType EncryptionAtRestWithCustomerKey { get; } = new RestorePointEncryptionType(EncryptionAtRestWithCustomerKeyValue);
        /// <summary> Disk Restore Point is encrypted at rest with 2 layers of encryption. One of the keys is Customer managed and the other key is Platform managed. </summary>
        public static RestorePointEncryptionType EncryptionAtRestWithPlatformAndCustomerKeys { get; } = new RestorePointEncryptionType(EncryptionAtRestWithPlatformAndCustomerKeysValue);
        /// <summary> Determines if two <see cref="RestorePointEncryptionType"/> values are the same. </summary>
        public static bool operator ==(RestorePointEncryptionType left, RestorePointEncryptionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RestorePointEncryptionType"/> values are not the same. </summary>
        public static bool operator !=(RestorePointEncryptionType left, RestorePointEncryptionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RestorePointEncryptionType"/>. </summary>
        public static implicit operator RestorePointEncryptionType(string value) => new RestorePointEncryptionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RestorePointEncryptionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RestorePointEncryptionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
