// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Compute.Models
{
    public partial class ResiliencyPolicy : IUtf8JsonSerializable, IJsonModel<ResiliencyPolicy>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ResiliencyPolicy>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ResiliencyPolicy>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResiliencyPolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResiliencyPolicy)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ResilientVmCreationPolicy))
            {
                writer.WritePropertyName("resilientVMCreationPolicy"u8);
                writer.WriteObjectValue(ResilientVmCreationPolicy, options);
            }
            if (Optional.IsDefined(ResilientVmDeletionPolicy))
            {
                writer.WritePropertyName("resilientVMDeletionPolicy"u8);
                writer.WriteObjectValue(ResilientVmDeletionPolicy, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ResiliencyPolicy IJsonModel<ResiliencyPolicy>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResiliencyPolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResiliencyPolicy)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeResiliencyPolicy(document.RootElement, options);
        }

        internal static ResiliencyPolicy DeserializeResiliencyPolicy(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResilientVmCreationPolicy resilientVmCreationPolicy = default;
            ResilientVmDeletionPolicy resilientVmDeletionPolicy = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("resilientVMCreationPolicy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resilientVmCreationPolicy = ResilientVmCreationPolicy.DeserializeResilientVmCreationPolicy(property.Value, options);
                    continue;
                }
                if (property.NameEquals("resilientVMDeletionPolicy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resilientVmDeletionPolicy = ResilientVmDeletionPolicy.DeserializeResilientVmDeletionPolicy(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ResiliencyPolicy(resilientVmCreationPolicy, resilientVmDeletionPolicy, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ResiliencyPolicy>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResiliencyPolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ResiliencyPolicy)} does not support writing '{options.Format}' format.");
            }
        }

        ResiliencyPolicy IPersistableModel<ResiliencyPolicy>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResiliencyPolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeResiliencyPolicy(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ResiliencyPolicy)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ResiliencyPolicy>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
