// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Gallery regional sharing status. </summary>
    public partial class RegionalSharingStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RegionalSharingStatus"/>. </summary>
        internal RegionalSharingStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RegionalSharingStatus"/>. </summary>
        /// <param name="region"> Region name. </param>
        /// <param name="state"> Gallery sharing state in current region. </param>
        /// <param name="details"> Details of gallery regional sharing failure. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RegionalSharingStatus(string region, SharingState? state, string details, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Region = region;
            State = state;
            Details = details;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Region name. </summary>
        public string Region { get; }
        /// <summary> Gallery sharing state in current region. </summary>
        public SharingState? State { get; }
        /// <summary> Details of gallery regional sharing failure. </summary>
        public string Details { get; }
    }
}
