// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> This is the regional replication state. </summary>
    public readonly partial struct RegionalReplicationState : IEquatable<RegionalReplicationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RegionalReplicationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RegionalReplicationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string ReplicatingValue = "Replicating";
        private const string CompletedValue = "Completed";
        private const string FailedValue = "Failed";

        /// <summary> Unknown. </summary>
        public static RegionalReplicationState Unknown { get; } = new RegionalReplicationState(UnknownValue);
        /// <summary> Replicating. </summary>
        public static RegionalReplicationState Replicating { get; } = new RegionalReplicationState(ReplicatingValue);
        /// <summary> Completed. </summary>
        public static RegionalReplicationState Completed { get; } = new RegionalReplicationState(CompletedValue);
        /// <summary> Failed. </summary>
        public static RegionalReplicationState Failed { get; } = new RegionalReplicationState(FailedValue);
        /// <summary> Determines if two <see cref="RegionalReplicationState"/> values are the same. </summary>
        public static bool operator ==(RegionalReplicationState left, RegionalReplicationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RegionalReplicationState"/> values are not the same. </summary>
        public static bool operator !=(RegionalReplicationState left, RegionalReplicationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RegionalReplicationState"/>. </summary>
        public static implicit operator RegionalReplicationState(string value) => new RegionalReplicationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RegionalReplicationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RegionalReplicationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
