// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> If this field is set on a snapshot and createOption is CopyStart, the snapshot will be copied at a quicker speed. </summary>
    public readonly partial struct ProvisionedBandwidthCopyOption : IEquatable<ProvisionedBandwidthCopyOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProvisionedBandwidthCopyOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProvisionedBandwidthCopyOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string EnhancedValue = "Enhanced";

        /// <summary> None. </summary>
        public static ProvisionedBandwidthCopyOption None { get; } = new ProvisionedBandwidthCopyOption(NoneValue);
        /// <summary> Enhanced. </summary>
        public static ProvisionedBandwidthCopyOption Enhanced { get; } = new ProvisionedBandwidthCopyOption(EnhancedValue);
        /// <summary> Determines if two <see cref="ProvisionedBandwidthCopyOption"/> values are the same. </summary>
        public static bool operator ==(ProvisionedBandwidthCopyOption left, ProvisionedBandwidthCopyOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProvisionedBandwidthCopyOption"/> values are not the same. </summary>
        public static bool operator !=(ProvisionedBandwidthCopyOption left, ProvisionedBandwidthCopyOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProvisionedBandwidthCopyOption"/>. </summary>
        public static implicit operator ProvisionedBandwidthCopyOption(string value) => new ProvisionedBandwidthCopyOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProvisionedBandwidthCopyOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProvisionedBandwidthCopyOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
