// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The overall success or failure status of the operation. It remains "InProgress" until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded", or "CompletedWithWarnings.". </summary>
    public readonly partial struct PatchOperationStatus : IEquatable<PatchOperationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PatchOperationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PatchOperationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string InProgressValue = "InProgress";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string CompletedWithWarningsValue = "CompletedWithWarnings";

        /// <summary> Unknown. </summary>
        public static PatchOperationStatus Unknown { get; } = new PatchOperationStatus(UnknownValue);
        /// <summary> InProgress. </summary>
        public static PatchOperationStatus InProgress { get; } = new PatchOperationStatus(InProgressValue);
        /// <summary> Failed. </summary>
        public static PatchOperationStatus Failed { get; } = new PatchOperationStatus(FailedValue);
        /// <summary> Succeeded. </summary>
        public static PatchOperationStatus Succeeded { get; } = new PatchOperationStatus(SucceededValue);
        /// <summary> CompletedWithWarnings. </summary>
        public static PatchOperationStatus CompletedWithWarnings { get; } = new PatchOperationStatus(CompletedWithWarningsValue);
        /// <summary> Determines if two <see cref="PatchOperationStatus"/> values are the same. </summary>
        public static bool operator ==(PatchOperationStatus left, PatchOperationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PatchOperationStatus"/> values are not the same. </summary>
        public static bool operator !=(PatchOperationStatus left, PatchOperationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PatchOperationStatus"/>. </summary>
        public static implicit operator PatchOperationStatus(string value) => new PatchOperationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PatchOperationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PatchOperationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
