// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Information about a specific patch that was encountered during an installation action. </summary>
    public partial class PatchInstallationDetail
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PatchInstallationDetail"/>. </summary>
        internal PatchInstallationDetail()
        {
            Classifications = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="PatchInstallationDetail"/>. </summary>
        /// <param name="patchId"> A unique identifier for the patch. </param>
        /// <param name="name"> The friendly name of the patch. </param>
        /// <param name="version"> The version string of the package. It may conform to Semantic Versioning. Only applies to Linux. </param>
        /// <param name="kbId"> The KBID of the patch. Only applies to Windows patches. </param>
        /// <param name="classifications"> The classification(s) of the patch as provided by the patch publisher. </param>
        /// <param name="installationState"> The state of the patch after the installation operation completed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PatchInstallationDetail(string patchId, string name, string version, string kbId, IReadOnlyList<string> classifications, PatchInstallationState? installationState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PatchId = patchId;
            Name = name;
            Version = version;
            KbId = kbId;
            Classifications = classifications;
            InstallationState = installationState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A unique identifier for the patch. </summary>
        public string PatchId { get; }
        /// <summary> The friendly name of the patch. </summary>
        public string Name { get; }
        /// <summary> The version string of the package. It may conform to Semantic Versioning. Only applies to Linux. </summary>
        public string Version { get; }
        /// <summary> The KBID of the patch. Only applies to Windows patches. </summary>
        public string KbId { get; }
        /// <summary> The classification(s) of the patch as provided by the patch publisher. </summary>
        public IReadOnlyList<string> Classifications { get; }
        /// <summary> The state of the patch after the installation operation completed. </summary>
        public PatchInstallationState? InstallationState { get; }
    }
}
