// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.&lt;br /&gt;&lt;br /&gt; Possible values are:&lt;br /&gt;&lt;br /&gt; **ImageDefault** - The virtual machine's default patching configuration is used. &lt;br /&gt;&lt;br /&gt; **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform. The property provisionVMAgent must be true. </summary>
    public readonly partial struct LinuxVmGuestPatchMode : IEquatable<LinuxVmGuestPatchMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LinuxVmGuestPatchMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LinuxVmGuestPatchMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ImageDefaultValue = "ImageDefault";
        private const string AutomaticByPlatformValue = "AutomaticByPlatform";

        /// <summary> ImageDefault. </summary>
        public static LinuxVmGuestPatchMode ImageDefault { get; } = new LinuxVmGuestPatchMode(ImageDefaultValue);
        /// <summary> AutomaticByPlatform. </summary>
        public static LinuxVmGuestPatchMode AutomaticByPlatform { get; } = new LinuxVmGuestPatchMode(AutomaticByPlatformValue);
        /// <summary> Determines if two <see cref="LinuxVmGuestPatchMode"/> values are the same. </summary>
        public static bool operator ==(LinuxVmGuestPatchMode left, LinuxVmGuestPatchMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LinuxVmGuestPatchMode"/> values are not the same. </summary>
        public static bool operator !=(LinuxVmGuestPatchMode left, LinuxVmGuestPatchMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LinuxVmGuestPatchMode"/>. </summary>
        public static implicit operator LinuxVmGuestPatchMode(string value) => new LinuxVmGuestPatchMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LinuxVmGuestPatchMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LinuxVmGuestPatchMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
