// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Describes a reference to Key Vault Key. </summary>
    public partial class KeyVaultKeyReference
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KeyVaultKeyReference"/>. </summary>
        /// <param name="keyUri"> The URL referencing a key encryption key in Key Vault. </param>
        /// <param name="sourceVault"> The relative URL of the Key Vault containing the key. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="keyUri"/> or <paramref name="sourceVault"/> is null. </exception>
        public KeyVaultKeyReference(Uri keyUri, WritableSubResource sourceVault)
        {
            Argument.AssertNotNull(keyUri, nameof(keyUri));
            Argument.AssertNotNull(sourceVault, nameof(sourceVault));

            KeyUri = keyUri;
            SourceVault = sourceVault;
        }

        /// <summary> Initializes a new instance of <see cref="KeyVaultKeyReference"/>. </summary>
        /// <param name="keyUri"> The URL referencing a key encryption key in Key Vault. </param>
        /// <param name="sourceVault"> The relative URL of the Key Vault containing the key. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KeyVaultKeyReference(Uri keyUri, WritableSubResource sourceVault, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyUri = keyUri;
            SourceVault = sourceVault;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="KeyVaultKeyReference"/> for deserialization. </summary>
        internal KeyVaultKeyReference()
        {
        }

        /// <summary> The URL referencing a key encryption key in Key Vault. </summary>
        public Uri KeyUri { get; set; }
        /// <summary> The relative URL of the Key Vault containing the key. </summary>
        internal WritableSubResource SourceVault { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier SourceVaultId
        {
            get => SourceVault is null ? default : SourceVault.Id;
            set
            {
                if (SourceVault is null)
                    SourceVault = new WritableSubResource();
                SourceVault.Id = value;
            }
        }
    }
}
