// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Compute.Models
{
    internal static partial class InstanceViewTypeExtensions
    {
        public static string ToSerialString(this InstanceViewType value) => value switch
        {
            InstanceViewType.InstanceView => "instanceView",
            InstanceViewType.UserData => "userData",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown InstanceViewType value.")
        };

        public static InstanceViewType ToInstanceViewType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "instanceView")) return InstanceViewType.InstanceView;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "userData")) return InstanceViewType.UserData;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown InstanceViewType value.");
        }
    }
}
