// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The security profile of a gallery image version. </summary>
    internal partial class ImageVersionSecurityProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ImageVersionSecurityProfile"/>. </summary>
        public ImageVersionSecurityProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ImageVersionSecurityProfile"/>. </summary>
        /// <param name="uefiSettings"> Contains UEFI settings for the image version. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ImageVersionSecurityProfile(GalleryImageVersionUefiSettings uefiSettings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UefiSettings = uefiSettings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Contains UEFI settings for the image version. </summary>
        public GalleryImageVersionUefiSettings UefiSettings { get; set; }
    }
}
