// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Describes the state of the image. </summary>
    public readonly partial struct ImageState : IEquatable<ImageState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ImageState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ImageState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string ScheduledForDeprecationValue = "ScheduledForDeprecation";
        private const string DeprecatedValue = "Deprecated";

        /// <summary> Active. </summary>
        public static ImageState Active { get; } = new ImageState(ActiveValue);
        /// <summary> ScheduledForDeprecation. </summary>
        public static ImageState ScheduledForDeprecation { get; } = new ImageState(ScheduledForDeprecationValue);
        /// <summary> Deprecated. </summary>
        public static ImageState Deprecated { get; } = new ImageState(DeprecatedValue);
        /// <summary> Determines if two <see cref="ImageState"/> values are the same. </summary>
        public static bool operator ==(ImageState left, ImageState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ImageState"/> values are not the same. </summary>
        public static bool operator !=(ImageState left, ImageState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ImageState"/>. </summary>
        public static implicit operator ImageState(string value) => new ImageState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ImageState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ImageState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
