// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Compute.Models
{
    public partial class ImageDeprecationStatus : IUtf8JsonSerializable, IJsonModel<ImageDeprecationStatus>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ImageDeprecationStatus>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ImageDeprecationStatus>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImageDeprecationStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ImageDeprecationStatus)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ImageState))
            {
                writer.WritePropertyName("imageState"u8);
                writer.WriteStringValue(ImageState.Value.ToString());
            }
            if (Optional.IsDefined(ScheduledDeprecationOn))
            {
                writer.WritePropertyName("scheduledDeprecationTime"u8);
                writer.WriteStringValue(ScheduledDeprecationOn.Value, "O");
            }
            if (Optional.IsDefined(AlternativeOption))
            {
                writer.WritePropertyName("alternativeOption"u8);
                writer.WriteObjectValue(AlternativeOption, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ImageDeprecationStatus IJsonModel<ImageDeprecationStatus>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImageDeprecationStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ImageDeprecationStatus)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeImageDeprecationStatus(document.RootElement, options);
        }

        internal static ImageDeprecationStatus DeserializeImageDeprecationStatus(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ImageState? imageState = default;
            DateTimeOffset? scheduledDeprecationTime = default;
            ImageAlternativeOption alternativeOption = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("imageState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    imageState = new ImageState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("scheduledDeprecationTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scheduledDeprecationTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("alternativeOption"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    alternativeOption = ImageAlternativeOption.DeserializeImageAlternativeOption(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ImageDeprecationStatus(imageState, scheduledDeprecationTime, alternativeOption, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ImageDeprecationStatus>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImageDeprecationStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ImageDeprecationStatus)} does not support writing '{options.Format}' format.");
            }
        }

        ImageDeprecationStatus IPersistableModel<ImageDeprecationStatus>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImageDeprecationStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeImageDeprecationStatus(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ImageDeprecationStatus)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ImageDeprecationStatus>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
