// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Describes the type of the alternative option. </summary>
    public readonly partial struct ImageAlternativeType : IEquatable<ImageAlternativeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ImageAlternativeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ImageAlternativeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string OfferValue = "Offer";
        private const string PlanValue = "Plan";

        /// <summary> None. </summary>
        public static ImageAlternativeType None { get; } = new ImageAlternativeType(NoneValue);
        /// <summary> Offer. </summary>
        public static ImageAlternativeType Offer { get; } = new ImageAlternativeType(OfferValue);
        /// <summary> Plan. </summary>
        public static ImageAlternativeType Plan { get; } = new ImageAlternativeType(PlanValue);
        /// <summary> Determines if two <see cref="ImageAlternativeType"/> values are the same. </summary>
        public static bool operator ==(ImageAlternativeType left, ImageAlternativeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ImageAlternativeType"/> values are not the same. </summary>
        public static bool operator !=(ImageAlternativeType left, ImageAlternativeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ImageAlternativeType"/>. </summary>
        public static implicit operator ImageAlternativeType(string value) => new ImageAlternativeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ImageAlternativeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ImageAlternativeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
