// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Compute.Models
{
    internal static partial class HostCachingExtensions
    {
        public static string ToSerialString(this HostCaching value) => value switch
        {
            HostCaching.None => "None",
            HostCaching.ReadOnly => "ReadOnly",
            HostCaching.ReadWrite => "ReadWrite",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HostCaching value.")
        };

        public static HostCaching ToHostCaching(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return HostCaching.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ReadOnly")) return HostCaching.ReadOnly;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ReadWrite")) return HostCaching.ReadWrite;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HostCaching value.");
        }
    }
}
