// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The GetVirtualMachineExpandType. </summary>
    public readonly partial struct GetVirtualMachineExpandType : IEquatable<GetVirtualMachineExpandType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GetVirtualMachineExpandType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GetVirtualMachineExpandType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InstanceViewValue = "instanceView";

        /// <summary> instanceView. </summary>
        public static GetVirtualMachineExpandType InstanceView { get; } = new GetVirtualMachineExpandType(InstanceViewValue);
        /// <summary> Determines if two <see cref="GetVirtualMachineExpandType"/> values are the same. </summary>
        public static bool operator ==(GetVirtualMachineExpandType left, GetVirtualMachineExpandType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GetVirtualMachineExpandType"/> values are not the same. </summary>
        public static bool operator !=(GetVirtualMachineExpandType left, GetVirtualMachineExpandType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GetVirtualMachineExpandType"/>. </summary>
        public static implicit operator GetVirtualMachineExpandType(string value) => new GetVirtualMachineExpandType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GetVirtualMachineExpandType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GetVirtualMachineExpandType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
