// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Optional parameter which specifies the mode to be used for replication. This property is not updatable. </summary>
    public readonly partial struct GalleryReplicationMode : IEquatable<GalleryReplicationMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GalleryReplicationMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GalleryReplicationMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FullValue = "Full";
        private const string ShallowValue = "Shallow";

        /// <summary> Full. </summary>
        public static GalleryReplicationMode Full { get; } = new GalleryReplicationMode(FullValue);
        /// <summary> Shallow. </summary>
        public static GalleryReplicationMode Shallow { get; } = new GalleryReplicationMode(ShallowValue);
        /// <summary> Determines if two <see cref="GalleryReplicationMode"/> values are the same. </summary>
        public static bool operator ==(GalleryReplicationMode left, GalleryReplicationMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GalleryReplicationMode"/> values are not the same. </summary>
        public static bool operator !=(GalleryReplicationMode left, GalleryReplicationMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GalleryReplicationMode"/>. </summary>
        public static implicit operator GalleryReplicationMode(string value) => new GalleryReplicationMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GalleryReplicationMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GalleryReplicationMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
