// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Describes the nature of the policy violation. </summary>
    public readonly partial struct GalleryImageVersionPolicyViolationCategory : IEquatable<GalleryImageVersionPolicyViolationCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GalleryImageVersionPolicyViolationCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GalleryImageVersionPolicyViolationCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string ImageFlaggedUnsafeValue = "ImageFlaggedUnsafe";
        private const string CopyrightValidationValue = "CopyrightValidation";
        private const string IPTheftValue = "IpTheft";

        /// <summary> Other. </summary>
        public static GalleryImageVersionPolicyViolationCategory Other { get; } = new GalleryImageVersionPolicyViolationCategory(OtherValue);
        /// <summary> ImageFlaggedUnsafe. </summary>
        public static GalleryImageVersionPolicyViolationCategory ImageFlaggedUnsafe { get; } = new GalleryImageVersionPolicyViolationCategory(ImageFlaggedUnsafeValue);
        /// <summary> CopyrightValidation. </summary>
        public static GalleryImageVersionPolicyViolationCategory CopyrightValidation { get; } = new GalleryImageVersionPolicyViolationCategory(CopyrightValidationValue);
        /// <summary> IpTheft. </summary>
        public static GalleryImageVersionPolicyViolationCategory IPTheft { get; } = new GalleryImageVersionPolicyViolationCategory(IPTheftValue);
        /// <summary> Determines if two <see cref="GalleryImageVersionPolicyViolationCategory"/> values are the same. </summary>
        public static bool operator ==(GalleryImageVersionPolicyViolationCategory left, GalleryImageVersionPolicyViolationCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GalleryImageVersionPolicyViolationCategory"/> values are not the same. </summary>
        public static bool operator !=(GalleryImageVersionPolicyViolationCategory left, GalleryImageVersionPolicyViolationCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GalleryImageVersionPolicyViolationCategory"/>. </summary>
        public static implicit operator GalleryImageVersionPolicyViolationCategory(string value) => new GalleryImageVersionPolicyViolationCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GalleryImageVersionPolicyViolationCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GalleryImageVersionPolicyViolationCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
