// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The source for the disk image. </summary>
    public partial class GalleryDiskImageSource : GalleryArtifactVersionSource
    {
        /// <summary> Initializes a new instance of <see cref="GalleryDiskImageSource"/>. </summary>
        public GalleryDiskImageSource()
        {
        }

        /// <summary> Initializes a new instance of <see cref="GalleryDiskImageSource"/>. </summary>
        /// <param name="id"> The id of the gallery artifact version source. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="uri"> The uri of the gallery artifact version source. Currently used to specify vhd/blob source. </param>
        /// <param name="storageAccountId"> The Storage Account Id that contains the vhd blob being used as a source for this artifact version. </param>
        internal GalleryDiskImageSource(ResourceIdentifier id, IDictionary<string, BinaryData> serializedAdditionalRawData, Uri uri, ResourceIdentifier storageAccountId) : base(id, serializedAdditionalRawData)
        {
            Uri = uri;
            StorageAccountId = storageAccountId;
        }
        /// <summary> The Storage Account Id that contains the vhd blob being used as a source for this artifact version. </summary>
        public ResourceIdentifier StorageAccountId { get; set; }
    }
}
