// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The ExpandTypesForListVm. </summary>
    public readonly partial struct ExpandTypesForListVm : IEquatable<ExpandTypesForListVm>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExpandTypesForListVm"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExpandTypesForListVm(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InstanceViewValue = "instanceView";

        /// <summary> instanceView. </summary>
        public static ExpandTypesForListVm InstanceView { get; } = new ExpandTypesForListVm(InstanceViewValue);
        /// <summary> Determines if two <see cref="ExpandTypesForListVm"/> values are the same. </summary>
        public static bool operator ==(ExpandTypesForListVm left, ExpandTypesForListVm right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExpandTypesForListVm"/> values are not the same. </summary>
        public static bool operator !=(ExpandTypesForListVm left, ExpandTypesForListVm right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExpandTypesForListVm"/>. </summary>
        public static implicit operator ExpandTypesForListVm(string value) => new ExpandTypesForListVm(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExpandTypesForListVm other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExpandTypesForListVm other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
