// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Script execution status. </summary>
    public readonly partial struct ExecutionState : IEquatable<ExecutionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExecutionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExecutionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string PendingValue = "Pending";
        private const string RunningValue = "Running";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string TimedOutValue = "TimedOut";
        private const string CanceledValue = "Canceled";

        /// <summary> Unknown. </summary>
        public static ExecutionState Unknown { get; } = new ExecutionState(UnknownValue);
        /// <summary> Pending. </summary>
        public static ExecutionState Pending { get; } = new ExecutionState(PendingValue);
        /// <summary> Running. </summary>
        public static ExecutionState Running { get; } = new ExecutionState(RunningValue);
        /// <summary> Failed. </summary>
        public static ExecutionState Failed { get; } = new ExecutionState(FailedValue);
        /// <summary> Succeeded. </summary>
        public static ExecutionState Succeeded { get; } = new ExecutionState(SucceededValue);
        /// <summary> TimedOut. </summary>
        public static ExecutionState TimedOut { get; } = new ExecutionState(TimedOutValue);
        /// <summary> Canceled. </summary>
        public static ExecutionState Canceled { get; } = new ExecutionState(CanceledValue);
        /// <summary> Determines if two <see cref="ExecutionState"/> values are the same. </summary>
        public static bool operator ==(ExecutionState left, ExecutionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExecutionState"/> values are not the same. </summary>
        public static bool operator !=(ExecutionState left, ExecutionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExecutionState"/>. </summary>
        public static implicit operator ExecutionState(string value) => new ExecutionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExecutionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExecutionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
