// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact. </summary>
    public partial class EncryptionImages
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EncryptionImages"/>. </summary>
        public EncryptionImages()
        {
            DataDiskImages = new ChangeTrackingList<DataDiskImageEncryption>();
        }

        /// <summary> Initializes a new instance of <see cref="EncryptionImages"/>. </summary>
        /// <param name="osDiskImage"> Contains encryption settings for an OS disk image. </param>
        /// <param name="dataDiskImages"> A list of encryption specifications for data disk images. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EncryptionImages(OSDiskImageEncryption osDiskImage, IList<DataDiskImageEncryption> dataDiskImages, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OSDiskImage = osDiskImage;
            DataDiskImages = dataDiskImages;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Contains encryption settings for an OS disk image. </summary>
        public OSDiskImageEncryption OSDiskImage { get; set; }
        /// <summary> A list of encryption specifications for data disk images. </summary>
        public IList<DataDiskImageEncryption> DataDiskImages { get; }
    }
}
