// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The instance view of a disk restore point. </summary>
    public partial class DiskRestorePointInstanceView
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DiskRestorePointInstanceView"/>. </summary>
        internal DiskRestorePointInstanceView()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DiskRestorePointInstanceView"/>. </summary>
        /// <param name="id"> Disk restore point Id. </param>
        /// <param name="replicationStatus"> The disk restore point replication status information. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DiskRestorePointInstanceView(string id, DiskRestorePointReplicationStatus replicationStatus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            ReplicationStatus = replicationStatus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Disk restore point Id. </summary>
        public string Id { get; }
        /// <summary> The disk restore point replication status information. </summary>
        public DiskRestorePointReplicationStatus ReplicationStatus { get; }
    }
}
