// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Used to specify the file format when making request for SAS on a VHDX file format snapshot. </summary>
    public readonly partial struct DiskImageFileFormat : IEquatable<DiskImageFileFormat>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DiskImageFileFormat"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DiskImageFileFormat(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string VhdValue = "VHD";
        private const string VhdxValue = "VHDX";

        /// <summary> A VHD file is a disk image file in the Virtual Hard Disk file format. </summary>
        public static DiskImageFileFormat Vhd { get; } = new DiskImageFileFormat(VhdValue);
        /// <summary> A VHDX file is a disk image file in the Virtual Hard Disk v2 file format. </summary>
        public static DiskImageFileFormat Vhdx { get; } = new DiskImageFileFormat(VhdxValue);
        /// <summary> Determines if two <see cref="DiskImageFileFormat"/> values are the same. </summary>
        public static bool operator ==(DiskImageFileFormat left, DiskImageFileFormat right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DiskImageFileFormat"/> values are not the same. </summary>
        public static bool operator !=(DiskImageFileFormat left, DiskImageFileFormat right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DiskImageFileFormat"/>. </summary>
        public static implicit operator DiskImageFileFormat(string value) => new DiskImageFileFormat(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DiskImageFileFormat other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DiskImageFileFormat other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
