// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Specifies the behavior of the managed disk when the VM gets deleted, for example whether the managed disk is deleted or detached. Supported values are: **Delete.** If this value is used, the managed disk is deleted when VM gets deleted. **Detach.** If this value is used, the managed disk is retained after VM gets deleted. Minimum api-version: 2021-03-01. </summary>
    public readonly partial struct DiskDeleteOptionType : IEquatable<DiskDeleteOptionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DiskDeleteOptionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DiskDeleteOptionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeleteValue = "Delete";
        private const string DetachValue = "Detach";

        /// <summary> Delete. </summary>
        public static DiskDeleteOptionType Delete { get; } = new DiskDeleteOptionType(DeleteValue);
        /// <summary> Detach. </summary>
        public static DiskDeleteOptionType Detach { get; } = new DiskDeleteOptionType(DetachValue);
        /// <summary> Determines if two <see cref="DiskDeleteOptionType"/> values are the same. </summary>
        public static bool operator ==(DiskDeleteOptionType left, DiskDeleteOptionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DiskDeleteOptionType"/> values are not the same. </summary>
        public static bool operator !=(DiskDeleteOptionType left, DiskDeleteOptionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DiskDeleteOptionType"/>. </summary>
        public static implicit operator DiskDeleteOptionType(string value) => new DiskDeleteOptionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DiskDeleteOptionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DiskDeleteOptionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
