// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Specifies the disk controller type configured for the VM and VirtualMachineScaleSet. This property is only supported for virtual machines whose operating system disk and VM sku supports Generation 2 (https://docs.microsoft.com/en-us/azure/virtual-machines/generation-2), please check the HyperVGenerations capability returned as part of VM sku capabilities in the response of Microsoft.Compute SKUs api for the region contains V2 (https://docs.microsoft.com/rest/api/compute/resourceskus/list). For more information about Disk Controller Types supported please refer to https://aka.ms/azure-diskcontrollertypes. </summary>
    public readonly partial struct DiskControllerType : IEquatable<DiskControllerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DiskControllerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DiskControllerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ScsiValue = "SCSI";
        private const string NVMeValue = "NVMe";

        /// <summary> SCSI. </summary>
        public static DiskControllerType Scsi { get; } = new DiskControllerType(ScsiValue);
        /// <summary> NVMe. </summary>
        public static DiskControllerType NVMe { get; } = new DiskControllerType(NVMeValue);
        /// <summary> Determines if two <see cref="DiskControllerType"/> values are the same. </summary>
        public static bool operator ==(DiskControllerType left, DiskControllerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DiskControllerType"/> values are not the same. </summary>
        public static bool operator !=(DiskControllerType left, DiskControllerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DiskControllerType"/>. </summary>
        public static implicit operator DiskControllerType(string value) => new DiskControllerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DiskControllerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DiskControllerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
