// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Additional authentication requirements when exporting or uploading to a disk or snapshot. </summary>
    public readonly partial struct DataAccessAuthMode : IEquatable<DataAccessAuthMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataAccessAuthMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataAccessAuthMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureActiveDirectoryValue = "AzureActiveDirectory";
        private const string NoneValue = "None";

        /// <summary> When export/upload URL is used, the system checks if the user has an identity in Azure Active Directory and has necessary permissions to export/upload the data. Please refer to aka.ms/DisksAzureADAuth. </summary>
        public static DataAccessAuthMode AzureActiveDirectory { get; } = new DataAccessAuthMode(AzureActiveDirectoryValue);
        /// <summary> No additional authentication would be performed when accessing export/upload URL. </summary>
        public static DataAccessAuthMode None { get; } = new DataAccessAuthMode(NoneValue);
        /// <summary> Determines if two <see cref="DataAccessAuthMode"/> values are the same. </summary>
        public static bool operator ==(DataAccessAuthMode left, DataAccessAuthMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataAccessAuthMode"/> values are not the same. </summary>
        public static bool operator !=(DataAccessAuthMode left, DataAccessAuthMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataAccessAuthMode"/>. </summary>
        public static implicit operator DataAccessAuthMode(string value) => new DataAccessAuthMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataAccessAuthMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataAccessAuthMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
