// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Indicates the error code if the background copy of a resource created via the CopyStart operation fails. </summary>
    public readonly partial struct CopyCompletionErrorReason : IEquatable<CopyCompletionErrorReason>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CopyCompletionErrorReason"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CopyCompletionErrorReason(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CopySourceNotFoundValue = "CopySourceNotFound";

        /// <summary> Indicates that the source snapshot was deleted while the background copy of the resource created via CopyStart operation was in progress. </summary>
        public static CopyCompletionErrorReason CopySourceNotFound { get; } = new CopyCompletionErrorReason(CopySourceNotFoundValue);
        /// <summary> Determines if two <see cref="CopyCompletionErrorReason"/> values are the same. </summary>
        public static bool operator ==(CopyCompletionErrorReason left, CopyCompletionErrorReason right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CopyCompletionErrorReason"/> values are not the same. </summary>
        public static bool operator !=(CopyCompletionErrorReason left, CopyCompletionErrorReason right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CopyCompletionErrorReason"/>. </summary>
        public static implicit operator CopyCompletionErrorReason(string value) => new CopyCompletionErrorReason(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CopyCompletionErrorReason other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CopyCompletionErrorReason other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
