// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Indicates the error details if the background copy of a resource created via the CopyStart operation fails. </summary>
    public partial class CopyCompletionError
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CopyCompletionError"/>. </summary>
        /// <param name="errorCode"> Indicates the error code if the background copy of a resource created via the CopyStart operation fails. </param>
        /// <param name="errorMessage"> Indicates the error message if the background copy of a resource created via the CopyStart operation fails. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="errorMessage"/> is null. </exception>
        public CopyCompletionError(CopyCompletionErrorReason errorCode, string errorMessage)
        {
            Argument.AssertNotNull(errorMessage, nameof(errorMessage));

            ErrorCode = errorCode;
            ErrorMessage = errorMessage;
        }

        /// <summary> Initializes a new instance of <see cref="CopyCompletionError"/>. </summary>
        /// <param name="errorCode"> Indicates the error code if the background copy of a resource created via the CopyStart operation fails. </param>
        /// <param name="errorMessage"> Indicates the error message if the background copy of a resource created via the CopyStart operation fails. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CopyCompletionError(CopyCompletionErrorReason errorCode, string errorMessage, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ErrorCode = errorCode;
            ErrorMessage = errorMessage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CopyCompletionError"/> for deserialization. </summary>
        internal CopyCompletionError()
        {
        }

        /// <summary> Indicates the error code if the background copy of a resource created via the CopyStart operation fails. </summary>
        public CopyCompletionErrorReason ErrorCode { get; set; }
        /// <summary> Indicates the error message if the background copy of a resource created via the CopyStart operation fails. </summary>
        public string ErrorMessage { get; set; }
    }
}
