// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> confidential VM encryption types. </summary>
    public readonly partial struct ConfidentialVmEncryptionType : IEquatable<ConfidentialVmEncryptionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConfidentialVmEncryptionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConfidentialVmEncryptionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EncryptedVmGuestStateOnlyWithPmkValue = "EncryptedVMGuestStateOnlyWithPmk";
        private const string EncryptedWithPmkValue = "EncryptedWithPmk";
        private const string EncryptedWithCmkValue = "EncryptedWithCmk";
        private const string NonPersistedTPMValue = "NonPersistedTPM";

        /// <summary> EncryptedVMGuestStateOnlyWithPmk. </summary>
        public static ConfidentialVmEncryptionType EncryptedVmGuestStateOnlyWithPmk { get; } = new ConfidentialVmEncryptionType(EncryptedVmGuestStateOnlyWithPmkValue);
        /// <summary> EncryptedWithPmk. </summary>
        public static ConfidentialVmEncryptionType EncryptedWithPmk { get; } = new ConfidentialVmEncryptionType(EncryptedWithPmkValue);
        /// <summary> EncryptedWithCmk. </summary>
        public static ConfidentialVmEncryptionType EncryptedWithCmk { get; } = new ConfidentialVmEncryptionType(EncryptedWithCmkValue);
        /// <summary> NonPersistedTPM. </summary>
        public static ConfidentialVmEncryptionType NonPersistedTPM { get; } = new ConfidentialVmEncryptionType(NonPersistedTPMValue);
        /// <summary> Determines if two <see cref="ConfidentialVmEncryptionType"/> values are the same. </summary>
        public static bool operator ==(ConfidentialVmEncryptionType left, ConfidentialVmEncryptionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConfidentialVmEncryptionType"/> values are not the same. </summary>
        public static bool operator !=(ConfidentialVmEncryptionType left, ConfidentialVmEncryptionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConfidentialVmEncryptionType"/>. </summary>
        public static implicit operator ConfidentialVmEncryptionType(string value) => new ConfidentialVmEncryptionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConfidentialVmEncryptionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConfidentialVmEncryptionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
