// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> An enum describing the unit of usage measurement. </summary>
    public readonly partial struct ComputeUsageUnit : IEquatable<ComputeUsageUnit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeUsageUnit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeUsageUnit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CountValue = "Count";

        /// <summary> Count. </summary>
        public static ComputeUsageUnit Count { get; } = new ComputeUsageUnit(CountValue);
        /// <summary> Determines if two <see cref="ComputeUsageUnit"/> values are the same. </summary>
        public static bool operator ==(ComputeUsageUnit left, ComputeUsageUnit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeUsageUnit"/> values are not the same. </summary>
        public static bool operator !=(ComputeUsageUnit left, ComputeUsageUnit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeUsageUnit"/>. </summary>
        public static implicit operator ComputeUsageUnit(string value) => new ComputeUsageUnit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeUsageUnit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeUsageUnit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
