// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Compute.Models
{
    internal static partial class ComputeStatusLevelTypeExtensions
    {
        public static string ToSerialString(this ComputeStatusLevelType value) => value switch
        {
            ComputeStatusLevelType.Info => "Info",
            ComputeStatusLevelType.Warning => "Warning",
            ComputeStatusLevelType.Error => "Error",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ComputeStatusLevelType value.")
        };

        public static ComputeStatusLevelType ToComputeStatusLevelType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Info")) return ComputeStatusLevelType.Info;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Warning")) return ComputeStatusLevelType.Warning;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Error")) return ComputeStatusLevelType.Error;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ComputeStatusLevelType value.");
        }
    }
}
