// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Compute.Models
{
    internal static partial class ComputeResourceSkuRestrictionsReasonCodeExtensions
    {
        public static string ToSerialString(this ComputeResourceSkuRestrictionsReasonCode value) => value switch
        {
            ComputeResourceSkuRestrictionsReasonCode.QuotaId => "QuotaId",
            ComputeResourceSkuRestrictionsReasonCode.NotAvailableForSubscription => "NotAvailableForSubscription",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ComputeResourceSkuRestrictionsReasonCode value.")
        };

        public static ComputeResourceSkuRestrictionsReasonCode ToComputeResourceSkuRestrictionsReasonCode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "QuotaId")) return ComputeResourceSkuRestrictionsReasonCode.QuotaId;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NotAvailableForSubscription")) return ComputeResourceSkuRestrictionsReasonCode.NotAvailableForSubscription;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ComputeResourceSkuRestrictionsReasonCode value.");
        }
    }
}
